SysInfo = {
	VersionNumber="???:U:A:A:2023040100";
}

--Settings.
--Use STORYDATA.data to access the player's current save data.
STORYDATA = {
	savefile='STORYDATA.json',
	DEBUG_UNLOCK_EVERYTHING=false,
	DEBUG_SKIP_SONG = false,
	CHAPTER_ORDER = {'testRoom','1_Thunder','4_Bronya'}, --'2_RFB','3_UMP45',
	CHAPTER_PORTRAITS={'none','M950A','Kyuushou'}, -- ,'AA12','MDR'
	FIRST_CHAPTER='1_Thunder',
	DEBUG_FLAG_NAMES = {
		"Intro Completed",
		"Tutorial Completed",
		"Met a3wr3af3fsefs34",
		"Finish Prologue",
		"At school"
	},
	--Unused currently
	TIME = {"Morning","Afternoon","Evening"},
	CURRENT_TIME = {
		1,
		2,
		3,
		1,
		2
	},
}

STORYDATA.GetChapterNumber=function(self,chapterName) --Yeah this was a really stupid idea. The idea was to allow the interpreter to load by file name and not have to index the chapter data but it clearly didn't work as well as I thought
	local cN = 0;
	for i,c in ipairs(self.CHAPTER_ORDER) do
		if chapterName == c then
			cN = i;
			return cN;
		end;
	end;
	ReportScriptError('the chapter name '..chapterName..' is not present in the database.')
	return -1;
end;

STORYDATA.GetLatestChapter=function(self)
	local completion = self['data']['_GLOBAL']['ChapterCompletion']
	for i=#completion,1,-1 do
		if completion[i] > 0 then
			return STORYDATA.CHAPTER_ORDER[i], completion[i]
		end;
		--[[for j=#completion[i],1,-1 do
			if completion[i][j]==true then
				return STORYDATA.CHAPTER_ORDER[completion], j+1
			end
		end]]
	end;
end;

STORYDATA.GenerateNewFile=function(self)
	local data = {
		['_VERSION']=SysInfo.VersionNumber,
		['_GLOBAL']={
			['Flags'] = {false,false,false,false,false,false,false}; --Why the fuck are there seven flags?
			['Vars'] = {0,0}, --eventNum, chapterNum. Var 2 is not needed tbh
			['ChapterCompletion']={}
			--[[['EventNum'] = 0,
			['ChapterNum'] = 0,]]
		},
		['TextSpeed']=50,
		--Anything filled in here is per-area
	};
	
	
	for i,v in ipairs(self.CHAPTER_ORDER) do
		data['_GLOBAL']['ChapterCompletion'][i]=0 --the number of events completed in this chapter
	end;
	
	return data
end;

STORYDATA.GetSaveDataPath=function(self,player)
	Trace(player);
	local profileDir = PROFILEMAN:GetProfileDir(ProfileSlot[PlayerNumber:Reverse()[player]+1])
	assert(profileDir ~= '',"No profile is loaded for "..player.." ("..ProfileSlot[PlayerNumber:Reverse()[player]+1].."). Cannot load/save story data.")
	return profileDir..self.savefile
end;

STORYDATA.SaveCurrentProgress=function(self,player)
	if not player then player = PLAYER_1 end;
	
	if not self['data'] then
		Warn("LoadCurrentProgress hasn't been called yet, there is nothing to save.");
		return false;
	end;
	--assert(self['data'],"LoadCurrentProgress hasn't been called yet!")
	
	
	
	local curChapter = self:GetChapterNumber(getenv('nextChapter'));
	self['data']['_GLOBAL']['ChapterCompletion'][curChapter]=tonumber(getenv('nextPart'))
	
	self['data']['_VERSION']=SysInfo.VersionNumber
	local path = self:GetSaveDataPath(player);
	local strToWrite = json.encode(self['data'])
	local file= RageFileUtil.CreateRageFile()
	if not file:Open(path, 2) then
		error("Could not open '" .. path .. "' to write quest mode save file.")
		return false;
	else
		file:Write(strToWrite)
		file:Close()
		file:destroy()
		return path
	end
end;

STORYDATA.LoadCurrentProgress=function(self,player)
	assert(player,"Need to provide which player to load the VN save data for, dingus.");
	local path = self:GetSaveDataPath(player);
	if FILEMAN:DoesFileExist(path) then
		local tempArr = json.decode(lua.ReadFile(path))
		if tempArr then
			self['data'] = tempArr
			return true;
		else
			return false;
		end;
	end;
	self['data']=self:GenerateNewFile();
	return true;
end;
